﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//Bitmask enum for flags for icons
public enum MinimapIconFlags
{
    LocalSpace = (1 << 0),
    NotOnMission = (1 << 1),
    MaintainRotation = (1 << 2)
}

//MinimapIcon is a class that represents an icon game object on the minimap
public class MinimapIcon : MonoBehaviour
{
    //Public properties
    public string IconName;
    public bool GetPositionFromReferenceGameObject;
    public GameObject ReferenceGameObject;
    public Vector2 IconPosition;
    public RectTransform RectTransform;
    public int Flags;

    /// <summary>
    /// Gets the position that the icon represents in world space
    /// </summary>
    /// <returns></returns>
    public Vector2 GetWorldPosition()
    {
        if(GetPositionFromReferenceGameObject)
        {
            //We'll get it from a reference game object, so let's try
            if(ReferenceGameObject != null)
            {
                return ReferenceGameObject.transform.position;
            }
        }

        else
        {
            //No reference, just an absolute set position so return it
            return IconPosition;
        }

        return Constants.SentinelVector3;   //Something went wrong, return sentinel
    }
}
